clear all; clc;

%%%%%  load GRACE data time period %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%  GRACE data %%%%%%%

ncfile='GRAVIS-3_2002095-2023059_COSTG_0100_AIS_GRID_TUD_0003.nc';

t_yr=ncread(ncfile,'time_dec');  % GRACE time


%%%%%  Load climate indices %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%% marshall sam %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[d] = textread('marshall.txt','','delimiter',' ','headerlines',2);
lag=0/12;
sam.yr = d(:,1)+ones(length(d),1)*[0:1/12:11/12]+lag;

sam.yr = reshape(sam.yr',length(sam.yr)*12,1) + (0.5/12);
sam.index.data = reshape(d(:,2:13)',length(sam.yr),1);

%%%%%%%  compute anomalies relative to 1971-2000 %%%%%%%%%%%%%%%%%%%%%%%%

i = find(sam.yr>=1971 & sam.yr<=2000);

sam.index.data = sam.index.data - nanmean(sam.index.data(i));

%%%%%   truncate SAM indices to GRACE time %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

i = find(sam.yr>=2002 & sam.yr<=(t_yr(end,1)+1/12));
sam.yr = sam.yr(i);
sam.index.data = sam.index.data(i);

%%%%%%% cumuatively sum indices %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sam.index.cum = cumsum(sam.index.data);

%%%%%%%%%%%%%%%% normalise cumulative %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sam.index.gc = sam.index.cum - nanmean(sam.index.cum);
sam.data = sam.index.gc/nanstd(sam.index.gc);

%%%%%%%%%%%%%%%  detrend and interpolate to GRACE time period %%%%%%%%%%%%

sam.datas=normalize(detrend(sam.data));
sm = interp1(sam.yr,sam.datas,t_yr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%  load Nino3.4 indices %%%%%%%%%%%%%%%%%%%%%%%%%%%

nino_3_4 = textread('nino.txt','','delimiter',' ','headerlines',1);
nino_3_4(nino_3_4==-99.99)= NaN;
lag=0/12;
nino.yr = nino_3_4(:,1)+ones(length(nino_3_4),1)*[0:1/12:11/12]+lag;
nino.yr = reshape(nino.yr',length(nino.yr)*12,1)+(0.5/12);

nino.index.data = reshape(nino_3_4(:,2:13)',length(nino.yr),1);
% remove NaNs
i=find(isnan(nino.index.data)==1);
nino.yr(i)=[];
nino.index.data(i)=[];

%%%%%%%  compute anomalies relative to 1971-2000 %%%%%%%%%%%%%%%%%%%%%%%%

i=find(nino.yr>=1971 & nino.yr <= 2000);
nino.index.data = nino.index.data - nanmean(nino.index.data(i));

%%%%%   truncate indices to GRACE time %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

i = find(nino.yr>=2002 & nino.yr<=(t_yr(end,1)+1/12));
nino.yr = nino.yr(i);
nino.index.data = nino.index.data(i);

%%%%%%% cumuatively sum indices %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

nino.index.cum = cumsum(nino.index.data);

%%%%%%%%%%%%%%%% normalise cumulative %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

nino.index.cum = nino.index.cum - nanmean(nino.index.cum);
nino.index.cum = nino.index.cum/nanstd(nino.index.cum);

%%%%%%%%%%%%%%%  detrend and interpolate to GRACE time period %%%%%%%%%%%%

nino.data=normalize(detrend(nino.index.cum));
ensos=(nino.data);
enso = interp1(nino.yr,ensos,t_yr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% plot indices %%%%%%%%%%%%%%%%%%%%%%%%%%%


figure
clf
% set(gcf,'outerposition',[0 0 600 900]);
% [ha, pos] = tight_subplot(3, 1, [0.00 0.00], [0.05 0.05], [0.00 0.00]);
set(gcf, 'DefaultAxesFontSize', 10.5);
set(gcf,'position',[67,300,752,474]);
[ha, pos] = tight_subplot(3, 2, [0.05 0.05], [0.07 0.05], [0.07 0.03]);

axes(ha(1))

h=plot(sam.yr,sam.index.data,...
    nino.yr,normalize(nino.index.data),...
	'linewidth',2);
set(gca,'xticklabel',[]);
text(0.05,0.9,texlabel('a)'),'units','normalized','FontWeight','normal');
title('Normalised indices','FontWeight','normal','FontSize',10);
ylabel('(Std.Dev)','FontWeight','normal','FontSize',10)

ylim([-6.5 4.5]);
axis tight

axes(ha(2))
 plot(nino.yr,normalize(detrend(nino.index.cum)),...
 	'k','linewidth',2);

axis tight

ylim([-2.5 3.5]);
text(0.05,0.9,texlabel('d)'),'units','normalized','FontWeight','normal');
ylabel('(Std.Dev)','FontWeight','normal','FontSize',10)
set(gca,'xticklabel',[]);

hold on
bb = [t_yr(1,1) t_yr(37,1)];
xp = [bb fliplr(bb)];                                                          
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                 
for k = 1:size(bb,1)                                                           
    patch(xp(k,:), yp(k,:), 'r', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end


hold on
bb = [t_yr(56,1) t_yr(82,1)];
xp = [bb fliplr(bb)];                                                         
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                 
for k = 1:size(bb,1)                                                            
    patch(xp(k,:), yp(k,:), 'b', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end
hold on
bb = [t_yr(82,1) t_yr(94,1)];
xp = [bb fliplr(bb)];                                                         
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                
for k = 1:size(bb,1)                                                            
    patch(xp(k,:), yp(k,:), 'r', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end

hold on
bb = [t_yr(94,1) t_yr(133,1)];
xp = [bb fliplr(bb)];                                                         
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                  
for k = 1:size(bb,1)                                                            
    patch(xp(k,:), yp(k,:), 'b', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end
hold on
bb = [t_yr(133,1) t_yr(154,1)];
xp = [bb fliplr(bb)];                                                         
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                  
for k = 1:size(bb,1)                                                             
    patch(xp(k,:), yp(k,:), 'r', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end

hold on
bb = [t_yr(154,1) t_yr(164,1)];
xp = [bb fliplr(bb)];                                                        
for k = 1:size(bb,1)                                                            
    patch(xp(k,:), yp(k,:), 'b', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end
hold on
bb = [t_yr(164,1) t_yr(184,1)];
xp = [bb fliplr(bb)];                                                        
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                 
for k = 1:size(bb,1)                                                            
    patch(xp(k,:), yp(k,:), 'r', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end

hold on
bb = [t_yr(184,1) t_yr(218,1)];
xp = [bb fliplr(bb)];                                                        
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                  
for k = 1:size(bb,1)                                                             
    patch(xp(k,:), yp(k,:), 'b', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end

title('ENSO (Cumulative summed)','FontWeight','normal','FontSize',10);

axes(ha(3))
plot(sam.yr,sam.data,...
    nino.yr,nino.index.cum,...
	'linewidth',2);
axis tight
ylim([-2.5 2.5])
text(0.05,0.9,texlabel('b)'),'units','normalized','FontWeight','normal');
set(gca,'xticklabel',[]);
title('Cumulatively summed indices','FontWeight','normal','FontSize',10);
ylabel('(Std.Dev)','FontWeight','normal','FontSize',10)

axes(ha(4))

plot(sam.yr,normalize(detrend(sam.data)),...
   	'k','linewidth',2);
axis tight
ylim([-2.5 3.5]);
text(0.05,0.9,texlabel('e)'),'units','normalized','FontWeight','normal');
hold on
bb = [t_yr(1,1) t_yr(94,1)];
xp = [bb fliplr(bb)];                                                         
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                  
for k = 1:size(bb,1)                                                             
    patch(xp(k,:), yp(k,:), 'b', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end
hold on
bb = [t_yr(138,1) t_yr(155,1)];
xp = [bb fliplr(bb)];                                                        
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                 
for k = 1:size(bb,1)                                                             
    patch(xp(k,:), yp(k,:), 'r', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end
hold on
bb = [t_yr(174,1) t_yr(189,1)];
xp = [bb fliplr(bb)];                                                         
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                 
for k = 1:size(bb,1)                                                            
    patch(xp(k,:), yp(k,:), 'b', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end

hold on
bb = [t_yr(189,1) t_yr(218,1)];
xp = [bb fliplr(bb)];                                                          
yp = ([[1;1]*min(ylim); [1;1]*max(ylim)]*ones(1,size(bb,1)))';                 
for k = 1:size(bb,1)                                                             
    patch(xp(k,:), yp(k,:), 'r', 'FaceAlpha',0.5, 'EdgeColor',[1 1 1]*0.25)
end
title('SAM (Cumulatively summed)','FontWeight','normal','FontSize',10);
ylabel('(Std.Dev)','FontWeight','normal','FontSize',10)

axes(ha(5))
plot(sam.yr,normalize(detrend(sam.data)),...
    nino.yr,normalize(detrend(nino.index.cum)),...
	'linewidth',2);
axis tight
ylim([-2.5 3.5]);
text(0.05,0.9,texlabel('c)'),'units','normalized','FontWeight','normal');
legend(ha(5),'SAM Marshall','Niño3.4','FontSize',10);
legend boxoff
title('Detrended Cumulatively summed indices','FontWeight','normal','FontSize',10);
ylabel('(Std.Dev)','FontWeight','normal','FontSize',10)
axes(ha(6))
axis off

% save
% print('Figure1', '-dpng', '-r300');
