clear; close all;clc
ncfile = 'GRAVIS-3_2002095-2023059_COSTG_0100_AIS_GRID_TUD_0003.nc';
dm = ncread(ncfile, 'dm');  
dm = dm(:,:,1:216);  % limit to Dec 2022
x = ncread(ncfile, 'x');  
y = ncread(ncfile, 'y'); 
t_yr=ncread(ncfile,'time_dec');  
t_yr = t_yr(1:216);  % limit to Dec 2022

enso_colormap = cptcmap('curl','ncol',23);
enso_colormap = flipud(enso_colormap);

%%%%%%%%%%   load antarctic coast line %%%%%%%%%%%%%%%%%%%%%%%%
cl = load('moa2014_grounding_line_v01.gmt');
c1=cl(:,1);c2=cl(:,2);

%%%%%%%%%%%%%%  load Antarctic basin shape fine %%%%%%%%%%%%%%

basins = shaperead('ANT_Basins_IMBIE2_v1.6.shp');

%%%%%%%%%%%%%%%% colormap %%%%%%%%%%%%%%%%%%%%%%%%%%%%

enso_colormap = cptcmap('curl','ncol',23);
enso_colormap = flipud(enso_colormap);
geopotential_colormap = cptcmap('GMT_polar','ncol',21);


%%%%%%% Smooth GRACE time to remove short-term noise %%%%%%%%%%

smt = smoothdata(dm, 3, "movmedian", 7/12, 'SamplePoints', t_yr); %%% 7-month window%
smt = detrend3(smt,t_yr);
%%%%%% load a ice sheet mask %%%%%%
load grace_mask;


%%%%%%%%%%%%%%%  ENSO indices 

%%%%%%%%%%%%%%%%%%%%%%%  load Nino3.4 indices %%%%%%%%%%%%%%%%%%%%%%%%%%%

nino_3_4 = textread('nino.txt','','delimiter',' ','headerlines',1);
nino_3_4(nino_3_4==-99.99)= NaN;
lag=0/12;
nino.yr = nino_3_4(:,1)+ones(length(nino_3_4),1)*[0:1/12:11/12]+lag;
nino.yr = reshape(nino.yr',length(nino.yr)*12,1)+(0.5/12);

nino.index.data = reshape(nino_3_4(:,2:13)',length(nino.yr),1);
% remove NaNs
i=find(isnan(nino.index.data)==1);
nino.yr(i)=[];
nino.index.data(i)=[];

%%%%%%%  compute anomalies relative to 1971-2000 %%%%%%%%%%%%%%%%%%%%%%%%

i=find(nino.yr>=1971 & nino.yr <= 2000);
nino.index.data = nino.index.data - nanmean(nino.index.data(i));

%%%%%   truncate indices to GRACE time %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

i = find(nino.yr>=2002 & nino.yr<=(t_yr(end,1)+1/12));
nino.yr = nino.yr(i);
nino.index.data = nino.index.data(i);

%%%%%%% cumuatively sum indices %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

nino.index.cum = cumsum(nino.index.data);

%%%%%%%%%%%%%%%% normalise cumulative %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

nino.index.cum = nino.index.cum - nanmean(nino.index.cum);
nino.index.cum = nino.index.cum/nanstd(nino.index.cum);

%%%%%%%%%%%%%%%  detrend and interpolate to GRACE time period %%%%%%%%%%%%

nino.data=normalize(detrend(nino.index.cum));
ensos=(nino.data);
enso = interp1(nino.yr,ensos,t_yr);

enso = enso(1:216,:); % limit to Dec 2022

%%%%% regresion between GRACE and ENSO %%%%%%%%%%%%
[nx,ny,~]= size(smt);

A = ([ones(length(enso),1) enso]);

ice = nan(nx,ny);
pval_ice = nan(nx,ny);
N = length(enso);

xx = numel(x);
yy = numel(y);



for i = 1:nx
    for j = 1:ny
        ts = squeeze(smt(i,j,:));  

        if all(isfinite(ts))
            % Linear regression
            [b, ~, r,~,stats] = regress(ts, A);
            beta = b(2);

            N = size(A,1);         
            p = size(A,2);         
            dof = N - p;           
            % Calculate standard error of slope
            XtX_inv = inv(A' * A);
            MSE = sum(r.^2) / dof;
            SE_beta = sqrt(MSE * XtX_inv(2,2));

            % t-statistic for slope
            t_stat = beta / SE_beta;

            % two-tailed p-value
            p = 2 * (1 - tcdf(abs(t_stat), dof));

            % Save
            ice(i,j) = beta;
            pval_ice(i,j) = p;
        end
    end
end
% load x
% load y
% load musk;
% load ensos;

%%%%%%%%%%%%%%%%%%  load RACMO SMB 

smbfile = 'smbgl_monthlyS_ANT11_RACMO2.4p1_ERA5_197901_202312.nc';
smb.data = squeeze(ncread(smbfile,'smbgl'));
smb.time = ncread(smbfile,'time');
smb.datenum = datenum(smb.time) + datenum('1950-01-01 00:00:00');
smb.t_yr = decyear(smb.datenum);
% xx =ncread(smbfile,'rlon');
% yy =ncread(smbfile,'rlat');
smb.lat = ncread(smbfile,'lat');
smb.lon = ncread(smbfile,'lon');

[smb.X,smb.Y]=polarstereo_fwd(smb.lat,smb.lon,[],[],-71);

[yr, mon, ~] = datevec(smb.datenum);
ii = find(yr>= 2002 & yr<=2022);
smb.data = smb.data(:,:,ii);
smb.t_yr = smb.t_yr(ii)

%%%%%%%%%%%%%%%%%  cumulatively sum SMB %%%%%%%%%%%%%%%%%%%%%%%%%%
smb.data = cumsum(smb.data-nanmean(smb.data,3),3);
smb.data = detrend3(smb.data,smb.t_yr);

%%%%%%%%%%%%%%%%%%%%%  interpolate SMB to GRACE grid %%%%%%%%%%%%%

smb.smb = nan(size(smt));

for k = 1:length(smb.t_yr)
  smb.smb(:,:,k)=griddata(smb.X,smb.Y,squeeze(smb.data(:,:,k)),x',y,'nearest')';
end

%%%%%%%%%%%%%  smooth data with a 7 month window %%%%%%%%%%%%%%%%%%%%%%

smb.smb = smoothdata(smb.smb,3,"movmedian",7/12,"SamplePoints",smb.t_yr);

%%%%%%%%%%%%%%%%%  regression between SMB and ENSO %%%%%%%%%%%%%%%%%%%%

smb1=nan(xx,yy);

A = ([ones(length(ensos),1) ensos]);

for i = 1:xx
    for k=1:yy

      ts = squeeze(smb.smb(i,k,:));
      if isfinite(ts(1))

       
            % Linear regression
            [b, ~, r,~,stats] = regress(ts, A);
            beta = b(2);
            N = size(A,1);         
            p = size(A,2);         
            dof = N - p;           
            % Calculate standard error of slope
            XtX_inv = inv(A' * A);
            MSE = sum(r.^2) / dof;
            SE_beta = sqrt(MSE * XtX_inv(2,2));

            % t-statistic for slope
            t_stat = beta / SE_beta;

            % two-tailed p-value
            p = 2 * (1 - tcdf(abs(t_stat), dof));

            smb1(i,k) = beta;
            pval_racmo(i,k) = p;
        end
    end
end

%%%%%%%%%%%% apply GRACE mask to the SMB  

smb1(grace_mask)=nan;
pval_racmo(grace_mask)= nan;



%%%%%%%%%%%%%%%%%%%%%%%%%%  ERA Sea Level pressure and 10m winds %%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%  load era5 data 

ncfile ='adaptor.mars.internal-1704285400.446974-8877-7-2e4e8ef9-e00b-436a-8494-c33e4dcd7e36.nc';

era5.u= squeeze(ncread(ncfile,'u10'));
era5.u= squeeze(era5.u(:,:,1,:));
era5.v=squeeze(ncread(ncfile,'v10'));
era5.v= squeeze(era5.v(:,:,1,:));
era5.lon =squeeze(ncread(ncfile,'longitude'));
era5.lat =squeeze(ncread(ncfile,'latitude'));
era5.msl = squeeze(ncread(ncfile,'msl'));
era5.msl= squeeze(era5.msl(:,:,1,:));
era5.t_yr = ncread(ncfile,'time');
era5.datenum = datenum(double(era5.t_yr)/24) + datenum('1900-01-01 00:00:00');
era5.t_yr = decyear(era5.datenum);
[llon,llat]=meshgrid(era5.lon,era5.lat);

%%%%%%%%%%%%%  project to polar spherical %%%%%%%%%%

[xl,yl]=ll2ps(llat,llon);

%%%%%%%%%%%%%%   limit time to 2002-2022

[yr, mon, ~] = datevec(era5.datenum);
ii = find(yr>= 2002 & yr<=2022);
era5.msl = era5.msl(:,:,ii);
era5.u = era5.u(:,:,ii);
era5.v = era5.v(:,:,ii);
era5.t_yr  = era5.t_yr(ii);
era5.datenum = era5.datenum(ii);

%%%%%%%% cumulatively sum variables %%%%%%%%%%%%%%%

era5.u = cumsum(era5.u-nanmean(era5.u,3),3);
era5.v = cumsum(era5.v-nanmean(era5.v,3),3);
era5.msl = cumsum(era5.msl-nanmean(era5.msl,3),3);

u =detrend3(era5.u,era5.t_yr);
v =detrend3(era5.v,era5.t_yr);
msl = detrend3(era5.msl,era5.t_yr);

msl_ano= msl./100; %%% convert to hPa
uv_ano = u;
vu_ano = v;

%%%%% regression between SLP/wind and ENSO 

xxx = numel(era5.lon);
yyy = numel(era5.lat);
g500e =nan(xxx,yyy);
pval_slp = nan(xxx,yyy);
uv = nan(xxx,yyy);
vu = nan(xxx,yyy);

 A = ([ones(length(ensos),1) ensos]);
for i = 1:xxx
    for k=1:yyy

      ts = squeeze(msl_ano(i,k,:));
      if isfinite(ts(1))
      
            % Linear regression
            [b, ~, r,~,stats] = regress(ts, A);
            beta = b(2);
            N = size(A,1);         
            p = size(A,2);         
            dof = N - p;           
            % Calculate standard error of slope
            XtX_inv = inv(A' * A);
            MSE = sum(r.^2) / dof;
            SE_beta = sqrt(MSE * XtX_inv(2,2));

            % t-statistic for slope
            t_stat = beta / SE_beta;

            % two-tailed p-value
            p = 2 * (1 - tcdf(abs(t_stat), dof));

            g500e(i,k) = beta;
            pval_slp(i,k) = p;
        end
    end
end

for i = 1:xxx
    for k=1:yyy

      ts = squeeze(uv_ano(i,k,:));
      if isfinite(ts(1))

        
         [slope] = regress(ts,A);
        uv(i,k)=slope(2) ;
        
         
    end
end
end

for i = 1:xxx
    for k=1:yyy

      ts = squeeze(vu_ano(i,k,:));
      if isfinite(ts(1))

        
         [slope] = regress(ts,A);
          vu(i,k)=slope(2) ;
        
         
    end
end
end

%%% convert wind to polar spherical 

[uwind,vwind] = uv2vxvy(llat,llon,uv',vu');

enso_msl = [g500e;g500e(1,:)];
pval_slp = [pval_slp;pval_slp(1,:)];
xy = [xl xl(:,1)];
yx = [yl yl(:,1)];

%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%  plot figure %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure
clf
set(gcf,'color','white')
set(gcf,'Position',[175 432 1009 400]);  % 

[ha, pos] = tight_subplot(1, 3, [0.00 -0.05], [0.25 0.08], [0.00 0.00]);

axes(ha(1))
pcolor(xy, yx, enso_msl'); shading interp; colormap(ha(1), geopotential_colormap);
caxis([-40 40]);
hold on
contour(xy,yx,enso_msl',-40:5:40,'w')
stipple(xy, yx, (pval_slp > 0.05)','density',150,'color','k','marker','.','markersize',3);
plot(c1, c2, 'k', 'LineWidth', 2);
title('a) ERA5 (SLP and winds)','FontWeight','normal','FontSize',16);
axis off
axis equal
hold on
quiversc(xl, yl, uwind, vwind, 'k','density',35,'maxheadsize',0.5)
cb1 = colorbar('southoutside',Position=[0.0257680872150644 0.12 0.294350842418236 0.0625]);
cb1.TickDirection='out';
cb1.TickLength=0.02;
cb1.FontSize =15;
windax = axes('Position', [0.144697720515362,0.1925,0.025,0.025]);  % Position above the main plot
hold on;
axis off
hold on;
axis off
% Plot a single wind vector with u = 1 (unit vector)
quiversc(0, 0, 1, 0, 'k','MaxHeadSize',1); 

text('Units','points','VerticalAlignment','bottom',...
    'HorizontalAlignment','center',...
    'String','1 m s^{-1} month',...
    'Position',[73.6170232187169,-2.7550769870904,0],...
    'FontSize',16);

text('Units','points','VerticalAlignment','bottom',...
    'HorizontalAlignment','center',...
    'String','hPa month',...
    'Position',[176.367023218717,-22.255076987090398,0],...
    'FontSize',16);

axes(ha(2))
pcolor(x,y,(smb1)');shading interp;colormap(ha(2),enso_colormap);
caxis([-200 200]);
axis off
axis image 
hold on;
stipple(x, y, (pval_racmo > 0.05)','density',150,'color','k','marker','.','markersize',3);
plot(c1,c2,'k');
hold on;
for k = 1:length(basins)
    plot(basins(k).X, basins(k).Y, 'k');
end
title('b) Cumulative SMB','FontWeight','normal','FontSize',16);

axes(ha(3))
pcolor(x,y,(ice)');shading interp;colormap(ha(3),enso_colormap);
caxis([-200 200]);
axis off
axis image 
hold on;
stipple(x, y, (pval_ice > 0.05)','density',150,'color','k','marker','.','markersize',3);
plot(c1,c2,'k');
hold on;
for k = 1:length(basins)
    plot(basins(k).X, basins(k).Y, 'k');
end
title('c) GRACE','FontWeight','normal','FontSize',16);
cb3 = colorbar('southoutside',Position=[0.555004955401388 0.1175 0.294350842418236 0.0625]);
cb3.TickDirection='out';
cb3.TickLength=0.02;
cb3.FontSize = 15;
 
 text('Units','points','VerticalAlignment','bottom',...
    'HorizontalAlignment','center',...
    'String','kg m^{-2}',...
    'Position',[177.617023218717,-40.2550769870904,0],...
    'FontSize',16);

 %%  save 
% print('Figure3', '-dpng', '-r300');


%%%%%%%%%%%%%%%%  create netcdfs 

outfile = 'GRACE_anomalies_regresion_against_cumulative_nino3_4_index.nc';

% Remove file if it already exists
if isfile(outfile)
    delete(outfile)
end

% Define dimensions
nccreate(outfile, 'x', 'Dimensions', {'x', length(x)}, 'Datatype', 'double');
nccreate(outfile, 'y', 'Dimensions', {'y', length(y)}, 'Datatype', 'double');

% Define variables
nccreate(outfile, 'ice', ...
    'Dimensions', {'x', length(x), 'y', length(y)}, ...
    'Datatype', 'double', 'DeflateLevel', 5);


nccreate(outfile, 'pval_ice', ...
    'Dimensions', {'x', length(x), 'y', length(y)}, ...
    'Datatype', 'double', 'DeflateLevel', 5);

%%%%%%%%%%%%%%%  Write data  %%%%%%%%%%%%%%%%%

ncwrite(outfile, 'x', x);
ncwrite(outfile, 'y', y);

ncwrite(outfile, 'ice', ice);
ncwrite(outfile, 'pval_ice', pval_ice);

%%%%%%%%%%%%%%%  Add metadata  %%%%%%%%%%%%%%%%%

ncwriteatt(outfile, '/', 'title', 'GRACE_anomalies_regresion_against_cumulative_nino3_4_index.nc');
ncwriteatt(outfile, '/', 'source', 'GRAVIS-3_2002095-2023059_COSTG_0100_AIS_GRID_TUD_0003.nc');
ncwriteatt(outfile, '/', 'time_period', '2002–2022');
ncwriteatt(outfile, 'ice', 'units', 'kg m^{-2}');
ncwriteatt(outfile, 'pval_ice', 'units', 'p-values');


%%%%%%%%   SMB 


outfile = 'SMB_anomalies_regresion_against_cumulative_nino3_4_index.nc';

% Remove file if it already exists
if isfile(outfile)
    delete(outfile)
end

% Define dimensions
nccreate(outfile, 'x', 'Dimensions', {'x', length(x)}, 'Datatype', 'double');
nccreate(outfile, 'y', 'Dimensions', {'y', length(y)}, 'Datatype', 'double');

% Define variables
nccreate(outfile, 'smb1', ...
    'Dimensions', {'x', length(x), 'y', length(y)}, ...
    'Datatype', 'double', 'DeflateLevel', 5);


nccreate(outfile, 'pval_racmo', ...
    'Dimensions', {'x', length(x), 'y', length(y)}, ...
    'Datatype', 'double', 'DeflateLevel', 5);

%%%%%%%%%%%%%%%  Write data  %%%%%%%%%%%%%%%%%

ncwrite(outfile, 'x', x);
ncwrite(outfile, 'y', y);

ncwrite(outfile, 'smb1', smb1);
ncwrite(outfile, 'pval_racmo', pval_racmo);

%%%%%%%%%%%%%%%  Add metadata  %%%%%%%%%%%%%%%%%

ncwriteatt(outfile, '/', 'title', 'Cumulative_SMB_anomalies_regresion_against_cumulative_nino3_4_index.nc');
ncwriteatt(outfile, '/', 'source', 'smbgl_monthlyS_ANT11_RACMO2.4p1_ERA5_197901_202312.nc');
ncwriteatt(outfile, '/', 'time_period', '2002–2022');
ncwriteatt(outfile, 'smb1', 'units', 'kg m^{-2}');
ncwriteatt(outfile, 'pval_racmo', 'units', 'p-values');

%%%%%%%% ERA% 5

outfile = 'Cumulative_ERA5_MSLP_anomalies_regresion_against_cumulative_nino3_4_index.nc';
% Delete file if it exists
if isfile(outfile)
    delete(outfile)
end


% Dimensions
ny = size(xy,1);   % 201
nx = size(yx,2);   % 1440

%%%%%%%%%%%% Create dimensions %%%%%%%%%%%%

nccreate(outfile,'lon','Dimensions',{'y',ny,'x',nx},'Datatype','double');
nccreate(outfile,'lat','Dimensions',{'y',ny,'x',nx},'Datatype','double');
nccreate(outfile,'enso_msl','Dimensions',{'y',ny,'x',nx},'Datatype','double','DeflateLevel',5);

%%%%%%%%%%%% Write data %%%%%%%%%%%% 
ncwrite(outfile,'lon',xy); 
ncwrite(outfile,'lat',yx);  
ncwrite(outfile,'enso_msl',enso_msl'); 


%%%%%%%%%%%% Add metadata %%%%%%%%%%%% 
ncwriteatt(outfile, '/', 'title', 'Cumulative_ERA5_MSLP_anomalies_regresion_against_cumulative_nino3_4_index.nc');
ncwriteatt(outfile, '/', 'source', 'ERA5 reanalysis');
ncwriteatt(outfile,'lon','long_name','longitude'); 
ncwriteatt(outfile,'lat','long_name','latitude'); 
ncwriteatt(outfile,'enso_msl','units','hPa/month'); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%