# README – Extreme Weather Effects on Marine Predator Breeding Outcomes in a Global Climate Change Hotspot



### Overview



This archive contains extreme weather events (EWEs) derived from weather datasets for breeding colonies of three marine predator species in Tasmania. It also includes   knitted R Markdown files that illustrate the code, calculation of EWE indices, fitted models, outputs, and analytical workflow for each study colony:



* EWE calculation – Step-by-step calculation of extreme weather indices from raw weather data
* Breeding colony ewes - Output data showing identified EWEs for a given colony
* Analytical flow – Example workflow linking EWEs to breeding outcomes



No biological or reproductive data are included. These remain with the data custodians - the Marine Conservation Program (NRE Tas) and the Friends of Maatsuyker Island (FOMI).





### Contents



##### 1\. EWE calculation



* Folder: EWE\_calculation
* Files named as: EWES\_XXXX, based on the colony name.
* Demonstrate the step-by-step process to calculate extreme weather indices from: BOM weather data, BARRA2 reanalysis data and CAWCR wave hindcast data.
* Definitions of all indices are provided in Table S2 of the Supplementary Materials.
* Weather stations are listed in Table S1.





##### 2\. EWE Indices data



* Folder: *Breeding\_colony\_ewes*
* Files are named using the specific colony name
* Contains colony-specific datasets of extreme weather indices derived from the above sources, following the methods in the publication.
* Each dataset includes: colony\_name – name of the breeding colony; season – breeding season, designated by the year egg-laying or pupping commenced; date – daily date stamp; extreme weather indices – all remaining columns



##### 3\. Analytical workflow



* Folder: Analytical\_flow
* Files named as: AUSF\_XXXX – Australian fur seal colonies, STSH\_XXXX – Short-tailed shearwater colonies, SHAL\_XXXX – Shy albatross colonies
* Demonstrate the complete analysis workflow used to link EWEs to breeding outcomes,
* Includes code, figures and model outputs.





### Notes



* Reproductive or biological data may be available upon request from the relevant custodians, including MCP (NRE Tas) and FOMI.
